/************* Include Files ***********************************/
#include "DX_VOS_BaseTypes.h"
#include "CRYS.h"
#include "tlk_odrm_types.h"
#include "KMNG_Defs.h" 
#include "ODRM_TLK_ATP_UTIL.h"
#include "KMNG_API.h"
#include "ODRM_SecROHandling_RoPreProcessing_ATP.h"
#include "tlk_odrm_api.h"
#include "DX_VOS_Mem.h"
#include "ODRM_SecROHandling_data.h"
#include "DX_VOS_Stdio.h"
#include "CRYS_KMNG.h"     
#include "tlk_odrm_errors.h"
#include "tlk_cert_types.h"
#include "tlk_sclk_api_types.h"
#include "DX_VOS_String.h"
#include "KMNG_API.h"
#include "tlk_sclk_api.h"
#include "MW_ATP_UTIL_funcs.h"
#include <stdio.h>
#include "tlk_odrm_errors.h"

DxError_t TST_SCLK_Init(TLK_SCLK_ServiceClockDescriptor_t* aServiceDescr)
{
    DxUint32_t TST_Error = 0;
    DxTime_t  TST_MaxAllowedDriftIn0_1Seconds = 0x150;
    DxTime_t  TST_MaximumRevalidationPeriod = 10;
    TLK_SCLK_ServiceClockTime_t  TST_ServiceTime;
    TLK_SCLK_ReadStatus_t       secureStatus = TLK_SCLK_STATUS_VALID;

    TLK_ODRM_Buffer_t passwordBuff;
    passwordBuff.buff_ptr        = TST_RiIDKey;
    passwordBuff.buffSizeInBytes = DX_VOS_StrLen(TST_RiIDKey);

    TST_Error = TLK_SCLK_ServiceClkGen(aServiceDescr,
        DX_NULL,
        TST_MaxAllowedDriftIn0_1Seconds,
        TST_MaximumRevalidationPeriod,
        TLK_SCLK_WORLD_READABLE,
        passwordBuff.buff_ptr,
        passwordBuff.buffSizeInBytes,
        RO_TST_gWorkspace,
        RO_TST_gWorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Error, "TLK_SCLK_ServiceClkGen",
                               "TST_SCLK_Init",
                               "TST_SCLK_Init");

    TST_Error = DX_VOS_MemCpy(&TST_ServiceTime,sizeof(TST_ServiceTime),
        ServiceTimeString, DX_VOS_StrLen(ServiceTimeString));

    TST_ATP_CHECK_ERROR_RETURN(TST_Error, "DX_VOS_MemCpy - TST_ServiceTime",
                               "TST_SCLK_Init",
                               "TST_SCLK_Init");

    TST_Error = TLK_SCLK_ServiceClkRevalidate(aServiceDescr, DX_NULL, 
                                              &TST_ServiceTime, TLK_SCLK_DATE_TIME_FORMAT, 
                                              (DxUint8*)passwordBuff.buff_ptr, passwordBuff.buffSizeInBytes,
                                              RO_TST_gWorkspace, RO_TST_gWorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Error, "TLK_SCLK_ServiceClkRevalidate",
                               "TST_SCLK_Init",
                               "TST_SCLK_Init");

    TST_ServiceTime.dateTimeFormat.year_m1 =3;

    TST_Error =  TLK_SCLK_ServiceClkRead(aServiceDescr, DX_NULL, &TST_ServiceTime, TLK_SCLK_DATE_TIME_FORMAT, &secureStatus, (DxUint8*)passwordBuff.buff_ptr, passwordBuff.buffSizeInBytes, RO_TST_gWorkspace, RO_TST_gWorkspaceSizeInBytes);


EXIT_ON_ERROR:
    return TST_Error;
}


DxError_t TST_KRING_Clean()
{
    DX_VOS_MemSetZero(TST_gKeyRingDevice,ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF);
    DX_VOS_MemSetZero(TST_gKeyRingDomain,ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF);
    DX_VOS_MemSetZero(TST_gKeyRingKmacKrec,ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF);
    DX_VOS_MemSetZero(TST_gParentKeyRingKmacKrec,ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF);

    return DX_SUCCESS;
}

DxError_t TST_VerifyKeyUsageFlag(DxUint32_t aKeyId, DxUint8_t* aKeyRing_ptr, DxUint32_t aFlagValue)
{
    DxUint32_t TST_Error = 0;
    KMNG_UserSpecificKeyData_t  TST_UserSpecificKeyData;
    KMNG_KeyType_t              TST_KeyType;
    DxUint32_t                  TST_KeySize = 0;  
    DxUint32_t                  TST_KeyUsage = 0;
    DxUint32_t                  TST_KeyRestriction = 0;

    TST_Error = KMNG_RetrieveUserKeyInform( aKeyId,
                                            &TST_KeyType,
                                            &TST_KeySize,
                                            &TST_KeyUsage,
                                            &TST_KeyRestriction,
                                            TST_UserSpecificKeyData,
                                            aKeyRing_ptr);
    TST_ATP_CHECK_ERROR_RETURN(TST_Error, "KMNG_RetrieveUserKeyInform",
                               "TST_VerifyKeyUsageFlag",
                               "TST_VerifyKeyUsageFlag");

    if ((TST_KeyUsage - aFlagValue) != 0)
    {
        TST_Error = TST_FAIL;
        TST_ATP_CHECK_ERROR_RETURN(TST_Error, "Invalid usage flag in key",
                                   "TST_VerifyKeyUsageFlag",
                                   "TST_VerifyKeyUsageFlag");
    }

EXIT_ON_ERROR:
    return TST_Error;
}